const mysql = require('mysql2/promise');
require('dotenv').config();

// Create connection pool
const pool = mysql.createPool({
  host: process.env.DB_HOST,
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0
});

// Test database connection
async function testConnection() {
  try {
    const [result] = await pool.query('SELECT 1 + 1 AS solution');
    console.log('Database connection successful');
    return true;
  } catch (error) {
    console.error('Database connection failed:', error);
    return false;
  }
}

// Debug function to check site_config contents
async function debugSiteConfig() {
  try {
    const [rows] = await pool.query('SELECT * FROM site_config WHERE config_key = ?', ['main']);
    if (rows.length > 0) {
      const config = JSON.parse(rows[0].config_value);
      console.log('SEO Config:', config.seo ? 'Found' : 'Not found');
      
      console.log('Google Analytics Code:', config.seo && config.seo.gaTrackingCode ? 
        `Found (${config.seo.gaTrackingCode.length} chars)` : 'Not found');
    } else {
      console.log('No site configuration found');
    }
  } catch (error) {
    console.error('Error checking site configuration:', error);
  }
}

module.exports = { pool, testConnection, debugSiteConfig };
